//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3
import QtQuick.Layouts  1.1

import wesual.Controls 1.0

import wesual.data.Core 1.0

GridLayout {
    id : tagEditor

    property TaggableDocument document
    property string type : ""

    rows : 2
    columns : 2
    columnSpacing : 4
    rowSpacing : 4

    TypeListing {
        id : tagListing
        context : tagEditor.document ? tagEditor.document.context : null
        type : tagEditor.type
    }
    DocumentListFilter {
        id : filteredTagListing
        documents : tagListing.documents
    }

    Label {
        text : tagEditor.document ? tagEditor.document.propertyName("tags") : ""
        Layout.maximumWidth : tagEditor.width / 3
    }

    TagPicker {
        Layout.fillWidth : true

        tags : filteredTagListing
        document : tagEditor.document

    }

    Item {
        Layout.maximumWidth : tagEditor.width / 3
        height : labelIndicator.height
    }

    ScrollView {
        id : labelIndicator

        Layout.fillWidth : true
        height : gridView.model ?
                     Math.min(80, gridView.model.length * gridView.cellHeight) :
                     0

        Layout.maximumHeight : 150

        TagButtonFlow {
            id : gridView

            tagNamePixelSize : 13
            tagIconSize : 18

            tagListing : {
                if (!document)
                    return [];
                else if (type === "")
                    return document.tags;
                else {
                    var filteredList = [];
                    for (var i = 0; i < document.tags.length; ++i) {
                        if (document.tags[i].type === type)
                            filteredList.push(document.tags[i]);
                    }
                    return filteredList;
                }
            }
            visible : implicitHeight > 0

            onRemoveTag : {
                tagEditor.document.beginRecordChanges();
                tagEditor.document.removeTag(tag);
                tagEditor.document.endRecordChanges();
            }
        }
    }

}
